Start-Transcript -Path "$env:TEMP\redbox-camera.log" -Append

Function Start-Installation
{
    param
    (
        [Parameter(Position=0,Mandatory=$true)]
        [System.String]$Exe
    )    
    $CmdLineArgs=@("/C","`"$Exe`"")
    Start-Process -FilePath "$env:windir\System32\cmd.exe" -ArgumentList $CmdLineArgs -Wait
}

$CurrentDirectory=[System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Definition)
$3rdGenHWID="USB\\VID_0C45"
$4thGenHWID="USB\\VID_1871"
$5thGenHWID="USB\\VID_11FA"
$3rdGenSetup="3rdGeneration\install.cmd"
$4thGenSetup="4thGeneration\install.cmd"
$5thGenSetup="5thGeneration\install.cmd"


$wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$3rdGenHWID%'"
$PnpDevices=Get-WmiObject -Query $wql
foreach ($PnpDevice in $PnpDevices)
{
    if($PnpDevice -ne $null)
    {
        Write-Host "Found 3rd Generation Camera $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)`r"
        $ExePath=Join-Path $CurrentDirectory $3rdGenSetup
        Start-Installation -Exe $ExePath
        break          
    }
}

$wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$4thGenHWID%'"
$PnpDevices=Get-WmiObject -Query $wql
foreach ($PnpDevice in $PnpDevices)
{
    if($PnpDevice -ne $null)
    {
        Write-Host "Found 4th Generation Camera $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)`r"
        $ExePath=Join-Path $CurrentDirectory $4thGenSetup
        Start-Installation -Exe $ExePath
        break          
    }
}

$wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$5thGenHWID%'"
$PnpDevices=Get-WmiObject -Query $wql
foreach ($PnpDevice in $PnpDevices)
{
    if($PnpDevice -ne $null)
    {
        Write-Host "Found 5th Generation Camera $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)`r"
        $ExePath=Join-Path $CurrentDirectory $5thGenSetup
        Start-Installation -Exe $ExePath
        break          
    }
}

Write-Host "Complete!"
Stop-Transcript|Out-Null